# addIPWhiteList {#addipwhitelist}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`addIPWhiteList(ips)`

## Arguments {#arguments}

**ips** is a STRING or IPADDR scalar/vector indicating one or more \(up to 65535\) IP addresses.

## Details {#details}

Add IP addresses to the whitelist. The whitelist feature is enabled when the first IP address is added. The whitelist and blacklist cannot be enabled simultaneously. After the whitelist feature is enabled, only the access requests from IP addresses in the whitelist are allowed. The local host 127.0.0.1 is included by default.

This function can only be executed by an administrator and takes effect on the cluster.

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
addIPWhiteList(["1.1.1.1", "2.2.2.2", "3.3.3.3"])
```

Related functions: [removeIPWhiteList](../r/removeipwhitelist.md), [getIPWhiteList](../g/getipwhitelist.md)

