# addRangePartitions {#addrangepartitions}

## Syntax {#syntax}

`addRangePartitions(dbHandle, newRanges, [level=0], [locations])`

## Arguments {#arguments}

**dbHandle** is a database handle.

**newRanges** is a vector indicating new partitions. The elements in the vector must be in ascending order. The first element must be the same as the last element or the original partition scheme.

**level** \(optional\) is a non-negative integer. For a partitioned database with COMPO domain, we need to specify the level of the partitions that `addRangePartitions` applies if it is not for the first level of partitions. This level must be of a RANGE domain. The default value is 0.

**locations** \(optional\) is a STRING scalar/vector. If the paramater *locations* was specified when the database was created, we can use *locations* to specify where the new partitions located.

## Details {#details}

Append new values to the partition scheme of a database. This database must be of RANGE domain or of COMPO domain with at least one level of RANGE domain. Note that the new partition can only be added after the last existing partition.

## Examples {#examples}

In the following example, we add 3 new ID partitions \[100,150\), \[150,200\) and \[200,250\) to the partition scheme of a database of COMPO domain.

```
n=1000000
ID=rand(100, n)
dates=2017.08.07..2017.08.11
date=rand(dates, n)
x=rand(10.0, n)
t=table(date, ID, x);
dbDate = database(, VALUE, 2017.08.07..2017.08.11)
dbID=database(, RANGE, 0 50 101);
db = database("dfs://compoDB", COMPO, [dbDate,dbID]);
pt = db.createPartitionedTable(t, `pt, `date`ID)
pt.append!(t);

addRangePartitions(db,101 150 200 250,1)
// output: 3
```

Before appending data to the new partitions, we need to reload the table.

```
db=database("dfs://compoDB")
pt=loadTable(db,"pt")

t1=table(rand(101..249,n) as ID,rand(2017.08.07..2017.08.11,n) as date,rand(10.0,n) as x)
pt.append!(t1);

select count(*) from loadTable("dfs://compoDB","pt");
// output: 2000000
```

To add new partitions consecutively without appending new data, we need to reload the database before each `addRangePartitions` operation.

```
db=database("dfs://compoDB")
pt=loadTable(db,"pt")

t1=table(rand(2017.08.07..2017.08.11,n) as date, rand(101..249,n) as ID, rand(10.0,n) as x)
pt.append!(t1);

select count(*) from loadTable("dfs://compoDB","pt");
//output: 2000000
```

