# addMCPPrompt {#addMCPPrompt}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`addMCPPrompt(name, message, [description], [extraInfo])`

## Arguments {#arguments}

**name** is a STRING scalar indicating the name of the prompt template.

**message** is a STRING scalar indicating the content of the prompt template. It can contain the placeholder `{}`.

**description** \(optional\) is a STRING scalar indicating the description of the prompt template.

**extraInfo** \(optional\) is a dictionary with STRING keys and ANY or STRING values used to specify additional information. Currently support "title" only.

## Details {#details}

Defines an MCP prompt template.

**Return value**: A string indicating the name of the newly added MCP prompt template.

## Examples {#examples}

``` {#codeblock_y55_32x_mgc}
addMCPPrompt(
  name = "stock_summary",
  message = "Summary the trend of ${stock} from ${startDate} to ${endDate}.",
  description = "Generate a natural-language overview of a stock over a time period",
  extraInfo = {title : "Stock Trend Summary"}
)

//output:'stock_summary'
```

