# addFunctionView {#addfunctionview}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`addFunctionView(udf|moduleName)`

## Arguments {#arguments}

**udf** is either a user-defined function or a tuple containing multiple user-defined functions.

**moduleName** is a STRING scalar indicating a module name.

Note:

-   Anonymous functions are not supported.
-   A user-defined function can only take scalars, pairs or regular vectors as default parameters.
-   The module specified by*moduleName*must be placed in the modules directory of the current node.
-   When module files have both *.dos* and *.dom* versions, *.dos* is loaded first.
-   When a module is loaded with `use <moduleName>` on the current node, and functions under a namespace with the same name are added as function views, the loaded module takes precedence if the function definitions are different.

## Details {#details}

Function view provides a flexible way to control user access to databases and tables. A function view is a user-defined function that encapsulates statements that access databases. Even if a user does not have the privilege to read the data of a database, the user can execute the function view to obtain the desired calculation result.

Specify user defined functions that can be executed by certain users although these users may not have TABLE\_READ access to the datasets that these functions operate on. For example, a user who cannot see individual patient names or ages may nevertheless calculate the number of patients and the average age of patients.

The specified user defined functions can be used as the value of the parameter *objs* if the parameter *accessType* is set to VIEW\_EXEC in command [grant](../g/grant.md), [deny](../d/deny.md) or [revoke](../r/revoke.md).

Unlike other user-defined functions that are session isolated, the function view can be shared between sessions. The definition of the function view is persisted to the controller node, so if the DolphinDB cluster is restarted, the previously defined function view can still be used.

`addFunctionView` can only be executed by administrators or users with VIEW\_OWNER permission.

## Examples {#examples}

In the following example, the user-defined function `getSpread` calculates the average bid-ask spread for a specified stock in the table *dfs://TAQ/quotes*. A user \(user1\) does not have the privilege to read table *dfs://TAQ/quotes*. Now define function `getSpread` to be a function view, and grant user1 the privilege to execute the function view. Although user1 cannot read the raw data of table *dfs://TAQ/quotes*, now she can execute the function view to calculate the average bid-ask spread of any stock in the table.

Please note that as table *dfs://TAQ/quotes* is a distributed database, the following script needs to be executed by a system administrator. User1 can execute function `getSpread` on any data node/compute node.

```
def getSpread(s, d){
    return select avg((ofr-bid)/(ofr+bid)*2) as spread from loadTable("dfs://TAQ","quotes") where symbol=s, date=d
}
```

```
addFunctionView(getSpread)

// grant privileges on a controller
grant("user1", VIEW_EXEC, "getSpread")
```

A module test.dos which defines functions `f1` and `f2` is placed under the modules directory:

``` {#codeblock_jzh_2r3_b1c}
addFunctionView("test")

// Grant user1 the execution privilege of f1
grant("user1", VIEW_EXEC, "test::f1")
// Grant user1 the execution privilege of all functions under test
grant(`user1, VIEW_EXEC, "test::*")

// A granted user can use the fully qualified name to call a function
test::f1()
```

Related functions: [dropFunctionView](../d/dropFunctionView.md)

