# addAccessControl {#addaccesscontrol}

## Syntax {#syntax}

`addAccessControl(table)`

## Arguments {#arguments}

**table** is a shared table or a streaming engine.

## Details {#details}

Add access control to the table created by the current user. Other users can access this table only after the administrator grants the privilege.

Note:

1.  It can only be executed by administrators or the table creator.

2.  If the administrator has set access privileges to the table for other users by `grant`/`deny`/`revoke`, access control will be automatically added without calling `addAccessControl`. Users that are not granted privileges by the administrator cannot access the table.


## Examples {#examples}

Create a user group for access management.

```
login(`admin, `123456)
createUser(`u1, "111111");
createUser(`u2, "222222");
createUser(`u3, "333333");
```

For streaming engines:

```
// user u1 create streaming engine agg1
login(`u1, "111111")
share streamTable(1000:0, `time`sym`volume, [TIMESTAMP, SYMBOL, INT]) as trades
output1 = table(10000:0, `time`sym`sumVolume, [TIMESTAMP, SYMBOL, INT])
agg1 = createTimeSeriesEngine(name="agg1", windowSize=60000, step=60000, metrics=<[sum(volume)]>, dummyTable=trades, outputTable=output1, timeColumn=`time, useSystemTime=false, keyColumn=`sym, garbageSize=50, useWindowStartTime=false)
subscribeTable(tableName="trades", actionName="agg1", offset=0, handler=append!{agg1}, msgAsTable=true);
// add access control for agg1
addAccessControl(agg1)

// user u2 logs in
login(`u2, "222222")

// insert data
insert into trades values(2018.10.08T01:01:01.785,`A,10) // 
insert into agg1 values(2018.10.08T01:01:01.785,`A,10) // ERROR: No access to table [agg1]

// drop stream engine
dropStreamEngine("agg1") // No access to drop stream engine agg1
```

For shared in-memory tables:

```
login(`u1, "111111")
t = table(take(`a`b`c`, 10) as sym, 1..10 as val)
share t as st;
addAccessControl(`st)

login(`u3, "333333")
select * from st // ERROR: No access to shared table [st]
insert into st values(`a, 4) // ERROR: No access to shared table [st]
```

