# acf {#acf}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`acf(X, maxLag)`

## Arguments {#arguments}

**X** is a vector.

**maxLag** is a positive integer.

## Details {#details}

Calculate the autocorrelation of *X* from lag=1 to lag=*maxLag*. Note that the means of the two time series used in the calculation is the mean of *X* instead of the means of the two time series.

## Examples {#examples}

```
n=10000
x=array(double, n, n, NULL)
x[0]=1
r=rand(0.05, n)-0.025
for(i in 0:(n-1)){
   x[i+1]=-0.8*x[i]+r[i]
}

acf = acf(x, 20)
plot(acf,chartType=BAR)
```

