# S06013 {#S06013}

## Error Code {#error_code .section}

S06013

## Error Message {#error_message .section}

`As long as one parameter sets a default value, all following parameters must set default values. RefId: S06013`

## Probable Causes {#probable_causes .section}

When defining a function, once a parameter is given a default value, all parameters that follow must also be assigned default values; otherwise, this error occurs.

For example, an error may arise in the following script because parameter "b" is given a default value while "c" that follow is not.

``` {#codeblock_xvt_r32_1cc}
def f(a, b=1, c) {
}
```

## Solutions {#solutions .section}

-   Put the parameter with a default value at the end of the parameter list.

-   Assign default values to all parameters following the first parameter with a default value


``` {#codeblock_y1y_s32_1cc}
def f(a, c, b=1) { // Put "b" at the end of the parameter list
}

def f(a, b=1, c=2) { // Assign a default value to "c" that follows "b"
}
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

