# S06012 {#S06012}

## Error Code {#error_code .section}

S06012

## Error Message {#error_message .section}

`A parameter with default value must be read only. RefId: S06012`

## Probable Causes {#probable_causes .section}

A parameter with a default value cannot be `mutable`; otherwise, this error occurs.

For example, an error may arise when defining the following named function because parameter "a" is given both a default value and a mutable decorator, which is not permitted.

``` {#codeblock_xvt_r32_1cc}
def f(mutable a=1) {
    print(a)
}
```

## Solutions {#solutions .section}

-   Parameters with a default value should be immutable.

-   Mutable parameters should not be assigned a default value.


For example:

``` {#codeblock_y1y_s32_1cc}
def f(mutable a) {
    print(a)
}

def f(a=1) {
    print(a)
}
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

