# S06010 {#S06010}

## Error Code {#error_code .section}

S06010

## Error Message {#error_message .section}

`To form a pair, both operands must have the same data category. RefId: S06009`

## Probable Causes {#probable_causes .section}

This error occurs when the keyword `IS` is not followed by `NULL` or `NOT NULL` \(case insensitive\).

For example:

``` {#codeblock_xvt_r32_1cc}
t = table([1,2,3] as id, [10,,30] as val)
select * from t where val is 10
```

## Solutions {#solutions .section}

Ensure that the keyword `IS` is followed by `NULL` or `NOT NULL` \(case insensitive\).

``` {#codeblock_y1y_s32_1cc}
t = table([1,2,3] as id, [10,,30] as val)
select * from t where val is null
select * from t where val is not null
select * from t where val = 10
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

