# S06007 {#S06007}

## Error Code {#error_code .section}

S06007

## Error Message {#error_message .section}

`Function <xxx> is declared but not defined yet. RefId: S06007`

## Probable Causes {#probable_causes .section}

This error occurs when an undefined function is declared.

For example:

``` {#codeblock_xvt_r32_1cc}
def f()  // Declare the function f

def g() {
    f()
}

// An error occurs since f is undefined
```

## Solutions {#solutions .section}

If a function is declared in a script, make sure that it is defined.

``` {#codeblock_y1y_s32_1cc}
def f()  // Declare the function f

def g() {
    f()
}

def f() {  // Define f
    print("Call f()")
}
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

