# S06002 {#s06002}

## Error Code {#error_code .section}

S06002

## Error Message {#error_message .section}

`'share' statement can't be declared within a function definition. RefId: S06002`

## Probable Causes {#probable_causes .section}

The `share` statement cannot be used within a function definition. Otherwise, this error will be reported. For example:

``` {#codeblock_odb_sdt_1bc}
def my_func() { 
    t = table(1 2 3 as id, 4 5 6 as val)
    share t as T
}
```

## Solutions {#solutions .section}

-   Do not use the `share` statement within a function definition.
-   Replace the `share` statement inside the function body with the `share` function.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

