# S06000 {#s06000}

## Error Code {#error_code .section}

S06000

## Error Message {#error_message .section}

`'=' or ':' is expected after the column name. RefId: S06000`

## Probable Causes {#probable_causes .section}

This error is raised due to incorrect format of SQL `update` statement.

syntax of `update`:

``` {#codeblock_qpf_sct_1bc}
update 
    [table_name]
    set col1=X1, [col2=X2,...]
    [from table_joiner(table_names)]
    [where condition(s)]
    [context by col_name(s)]
```

where the set clause must follow the format:

``` {#codeblock_axx_sct_1bc}
column_name equal_sign(=) or colon(:) expression
```

If the column name is not followed by an equal sign \(=\) or a colon \(:\), this error will be reported. For example:

``` {#codeblock_br3_tct_1bc}
t = table(1 2 3 as id, 10 20 30 as val)
update t set val where id = 1  // '=' or ':' is expected after the column name.
```

## Solutions {#solutions .section}

Modify the statement following the syntax.

The above scripts can be modified to either of the following:

``` {#codeblock_dt1_5ct_1bc}
update t set val = val + 1 where id = 1 
update t set val : val + 1 where id = 1
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

