# S05016 {#S05016}

## Error Code {#error_code .section}

S05016

## Error Message {#error_message .section}

`An in-memory table can't exceed 2 billion rows. RefId: S05016`

## Probable Causes {#probable_causes .section}

This error occurs when the number of rows for an in-memory table exceeds its limit — 2,147,483,647.

For example, an error may arise at the second data appending because the number of rows, 2147483648, exceeds the limit.

``` {#codeblock_ftm_2rz_zbc}
t = table(2147483646l:2147483646l, `a`b, [INT, INT])
t.append!(table([1] as a, [2] as b))
t.append!(table([1] as a, [2] as b))  // Error
```

## Solutions {#solutions .section}

Ensure that the number of rows for each in-memory table does not exceed 2,147,483,647.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

