# S05015 {#S05015}

## Error Code {#error_code .section}

S05015

## Error Message {#error_message .section}

`Can't drop a key column. RefId: S05015`

## Probable Causes {#probable_causes .section}

This error occurs when the key column of a keyed or indexed in-memory table is deleted.

For example:

``` {#codeblock_ftm_2rz_zbc}
t = keyedTable(`id, table(1 2 3 as id, 10 20 30 as val))
t.dropColumns!(`id)

t = indexedTable(`id, table(1 2 3 as id, 10 20 30 as val))
t.dropColumns!(`id)
```

## Solutions {#solutions .section}

Do not delete any key column of keyed or indexed in-memory tables.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

