# S05014 {#S05014}

## Error Code {#error_code .section}

S05014

## Error Message {#error_message .section}

`The column <xxx> does not exist. To add a new column, the size of the new column must equal to the size of the table. RefId: S05014`

## Probable Causes {#probable_causes .section}

When attempting to add a column to an in-memory table with a referencing column, this error may occur if the number of rows in the new column does not match that of the original table.

For example, an error may arise because the original table contains 3 rows, while the added column contains 4.

``` {#codeblock_ftm_2rz_zbc}
t = table(1 2 3 as id, 10 20 30 as val)
t[`a] = 4 5 6 7
```

## Solutions {#solutions .section}

When adding a column to an in-memory table through indices, ensure that the number of rows in the added column is the same to that of the original table.

``` {#codeblock_s4j_1sz_zbc}
t = table(1 2 3 as id, 10 20 30 as val)
t[`a] = 4 5 6
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

