# S05012 {#S05012}

## Error Code {#error_code .section}

S05012

## Error Message {#error_message .section}

`A keyed/indexed table can't contain duplicated keys. RefId: S05012`

## Probable Causes {#probable_causes .section}

This error occurs when there are duplicated keys in a keyed or indexed in-memory table.

For example, this error is reported in the following cases:

``` {#codeblock_ftm_2rz_zbc}
id = 1 2 3 1
val = 10 20 30 40
t = keyedTable(`id, id, val)
t = indexedTable(`id, id, val)

t = keyedTable(`id, table(1 2 3 1 as id, 10 20 30 40 as val))
t = indexedTable(`id, table(1 2 3 1 as id, 10 20 30 40 as val))
```

## Solutions {#solutions .section}

Remove the duplicated keys in keyed or indexed in-memory tables.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

