# S05011 {#S05011}

## Error Code {#error_code .section}

S05011

## Error Message {#error_message .section}

`The number of contiguous vector elements has reached its maximum. RefId: S05011`

## Probable Causes {#probable_causes .section}

Regular arrays \(referring to array types other than [Big Array](../../Programming/DataTypesandStructures/DataForms/Vector/BigArray.md), see [Data Forms](../../Programming/DataTypesandStructures/DataForms/DataForms.md)\) use continuous memory. This error occurs when the written data exceeds the memory limit, which is determined by the configuration parameter *regularArrayMemoryLimit* with a default value of 2048 MB.

For example, an error may arise at the third time of data appending because the written data, 536870913, exceeds the memory limit.

``` {#codeblock_ftm_2rz_zbc}
// Each INT element occupies 4 bytes, so the default memory limit for a regular array of the INT type is:
//   2048l << 20 / 4 = 536,870,912
v = array(INT, 536870910)
v.append!(1)
v.append!(1)
v.append!(1)  // Error
```

## Solutions {#solutions .section}

Use [Big Array](../../Programming/DataTypesandStructures/DataForms/Vector/BigArray.md).

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

