# S05009 {#S05009}

## Error Code {#error_code .section}

S05009

## Error Message {#error_message .section}

`The scale of Decimal should be an integer. RefId: S05009`

## Probable Causes {#probable_causes .section}

This error occurs when the *scale* of a DECIMAL value is not an integer.

For example, an error may arise because the *scale* of the DECIMAL value is of STRING type.

``` {#codeblock_ftm_2rz_zbc}
v = array(DECIMAL32("2"))
```

## Solutions {#solutions .section}

Set the *scale* of each DECIMAL value to an integer.

``` {#codeblock_tvb_3rz_zbc}
v = array(DECIMAL32(2))
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

