# S05008 {#S05008}

## Error Code {#error_code .section}

S05008

## Error Message {#error_message .section}

`Must specify scale for Decimal data type, e.g., DECIMAL32(2). RefId: S05008`

## Probable Causes {#probable_causes .section}

This error occurs when the *scale* \(denoting the number of decimal places\) of a DECIMAL value is unspecified. For details, see [Data Types](../../Programming/DataTypesandStructures/DataTypes/DataTypes.md).

For example, an error may arise because the *scale* of the following DECIMAL values is unspecified.

``` {#codeblock_ftm_2rz_zbc}
v = array(DECIMAL32)

v = array(DECIMAL32[])

t = table(100:0, `c1`c2, [INT, DECIMAL64])
```

## Solutions {#solutions .section}

Specify the *scale*for each DECIMAL value.

``` {#codeblock_tvb_3rz_zbc}
v = array(DECIMAL32(2))

v = array(DECIMAL32(2)[])

t = table(100:0, `c1`c2, [INT, DECIMAL64(5)])
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

