# S05007 {#s05007}

## Error Code {#error_code .section}

S05007

## Error Message {#error_message .section}

`All elements of the input tuple must have the same length. RefId:S05007`

## Probable Causes {#probable_causes .section}

When calling the `upsert!` function, if *newData* is a tuple and the elements of the tuple have different lengths, this error is raised.

``` {#codeblock_frq_vgt_1bc}
x = 1 2 3
y = 5 6 7
t = keyedTable(`x, x, y)
// The first element of newData has two values, but the second has three
t.upsert!((1 2, 50 60 70))
```

## Solutions {#solutions .section}

If *newData* is a tuple, all elements of the tuple must have the same length. For example, the above script can be modified as follows:

``` {#codeblock_zpf_wgt_1bc}
x = 1 2 3
y = 5 6 7
t = keyedTable(`x, x, y)
t.upsert!((1 2, 50 60))
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

