# S05006 {#s05006}

## Error Code {#error_code .section}

S05006

## Error Message {#error_message .section}

`The number of columns to be updated must match the number of columns specified in colNames. RefId:S05006`

## Probable Causes {#probable_causes .section}

When calling the `update!` function, if *colNames* contains multiple values \(i.e., updating multiple columns\) and*newValues* is not a lambda function but the data to update with, the number of elements in *colNames*must match the number of elements in *newValues*. Otherwise, this error will be raised.

``` {#codeblock_p1m_rgt_1bc}
t = table(1 2 3 as id, 4 5 6 as val)
// update two columns, but newValues has only one element
t.update!(`id`val, ([10, 20, 30]))
```

## Solutions {#solutions .section}

Ensure that the number of columns to be updated matches the number of new values provided. For example, the above script can be modified as follows:

``` {#codeblock_vkd_sgt_1bc}
t = table(1 2 3 as id, 4 5 6 as val)
t.update!(`id`val, ([10, 20, 30], [40, 50, 60]))
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

