# S05003 {#s05003}

## Error Code {#error_code .section}

S05003

## Error Message {#error_message .section}

`DECIMAL math overflow RefId:S05003`

## Probable Causes {#probable_causes .section}

The DECIMAL type is stored using signed integers internally in DolphinDB, specifically:

-   DECIMAL32 uses `int32_t`
-   DECIMAL64 uses `int64_t`
-   DECIMAL128 uses `int128_t`

For an N-bit signed integer, the representable range is \[-1 \* 2 ^ \(N-1\), 2 ^ \(N-1\) - 1\]. This error is reported when the signed integer representing the DECIMAL value exceeds the range. For example:

-   Calculations \(e.g., functions, SQL\) involving DECIMAL values.

-   Conversion of other data types to DECIMAL.

-   Conversion between DECIMAL types or DECIMALs with different scales.


## Solutions {#solutions .section}

-   Use a DECIMAL type with a larger representable range, such as DECIMAL128.
-   Lower the *scale* parameter of the DECIMAL type. For example, if only 5 decimal places are needed, set *scale* to 5.
-   Use FLOAT/DOUBLE type instead of DECIMAL.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

