# S05001 {#s05001}

## Error Code {#error_code .section}

S05001

## Error Message {#error_message .section}

`A set does not support random access. RefId:S05001`

## Probable Causes {#probable_causes .section}

The set in DolphinDB is implemented using a hash table, which does not support random access. This error occurs when attempting to access a set using index or iterating over it with a `for` loop.

For example:

``` {#codeblock_exb_bgt_1bc}
x=set(4 5 5 2 3 11 6)
// Accessing a set using an index
x[0]
// Iterating over a set with a for loop
for (i in x) {}
```

## Solutions {#solutions .section}

-   Check if an element exist in a set with the `in` operator:

    ``` {#codeblock_jpx_cgt_1bc}
    x = set(1 2 3)
    1 in x  // true
    [1,3,4] in x  // [true, true, false] 
    ```

-   To iterate over the elements of a set, first convert it to a vector with the `keys` function:

    ``` {#codeblock_a1n_dgt_1bc}
    x = set(1 2 3)
    for (i in x.keys()) {
    }
    ```


**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

