# S04005 {#s04005}

## Error Code {#error_code .section}

S04005

## Error Message {#error_message .section}

`To manage permissions for databases you didn't create, you must have the DB_MANAGE privilege or contact an administrator. RefId: S04005`

## Probable Causes {#probable_causes .section}

This error occurs when non-admin users attempt to manage privileges for databases they have no permission for.

## Solutions {#solutions .section}

Non-admin users can only be set the following privileges and the permission scope can be global \(\*\). Users must also have the corresponding permission for *objs*, as shown in the following table:

<table id="table_tn1_4z1_zzb"><thead><tr><th align="left">

Privilege Type

</th><th align="left">

Required Permission

</th></tr></thead><tbody><tr><td align="left">

-   TABLE\_READ
-   TABLE\_WRITE
-   TABLE\_INSERT
-   TABLE\_UPDATE
-   TABLE\_DELETE

</td><td align="left">

Users must have the DB\_MANAGE privilege for the database where the specified table is located, or be the creator of the database.

</td></tr><tr><td align="left">

-   DB\_READ
-   DB\_WRITE
-   DB\_INSERT
-   DB\_UPDATE
-   DB\_DELETE
-   DBOBJ\_DELETE
-   DBOBJ\_CREATE

</td><td align="left">

Users must have the DB\_MANAGE privilege for the specified database, or be the creator of the database.

</td></tr><tr><td align="left">

-   VIEW\_EXEC

</td><td align="left">

Users must have the VIEW\_OWNER privilege and be the creator of the specified function view.

</td></tr></tbody>
</table>**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

