# S03019 {#s03019}

## Error Code {#error_code .section}

S03019

## Error Message {#error_message .section}

`The volume of data exceeds the compression limit. Try inserting data in smaller batches, or adjust the replay rate. PersistenceManager fail to compress data: {errMsg}. RefId: S03019`

## Probable Causes {#probable_causes .section}

After enabling persistence for a stream table, data is persisted to disk after being written to memory. The data to be appended in a single batch is compressed before writing to disk. This error occurs during the compression step of the persistence process.

The issue may arise when the replay rate is too high, or the batch size of data being inserted is too large, exceeding the compression limit for the given scenario.

## Solutions {#solutions .section}

-   Adjust the replay rate when replaying data to a persisted stream table.
-   Set a smaller batch size when appending data to a persisted stream table.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

