# S03017 {#s03017}

## Error Code {#error_code .section}

S03017

## Error Message {#error_message .section}

`Failed to append data to column <xxx> with error: Incompatible type. Expected: <Type1>, Actual: <Type2>. RefId:S03017`

## Probable Causes {#probable_causes .section}

This error occurs when attempting to write data of Type2 to a column of Type1 of a stream table, where Type1 and Type2 are incompatible types. Specifically,

1.  When appending data to a stream table \(with `append!` or `insert into`\), its schema does not match the table schema.
2.  When calling `enableTableShareAndPersistence`, a table with the same name already exists in the persistence directory, and the table schema does not match that specified in the function.

## Solutions {#solutions .section}

1.  For the first case, check and modify the schema of data to be appended.
2.  For the second case, check and modify the schema of *table*specified in `enableTableShareAndPersistence`, or clean up the persisted files before enabling persistence.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

