# S03003 {#s03003}

## Error Code {#error_code .section}

S03003

## Error Message {#error_message .section}

`All subscriptions to the stream table <xxx> must be canceled before it can be dropped. Call getStreamingStat().pubTables to get the status of all stream tables. RefId: S03003`

## Probable Causes {#probable_causes .section}

A stream table can be subscribed by:

-   the node where the table is located

-   other nodes in the cluster

-   an API client


The aforementioned three subscriptions will prevent the stream table from being undefined or destroyed. Only when all subscriptions to the table are canceled, can it be dropped with the `dropStreamTable` function or the `drop` statement.

## Solutions {#solutions .section}

Call the `getStreamingStat` function to monitor the subscriptions to the stream table:

-   Check the subscriptions to the table with `getStreamingStat().pubTables`.

-   Check the connections between the local publisher node and all of its subscriber nodes with `getStreamingStat().pubConns`.


Then, use the `unsubscribeTable` function to cancel the subscriptions. Once all subscriptions are canceled, the stream table can be dropped.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

