# S02059 {#S02059}

## Error Code {#error_code .section}

S02059

## Error Message {#error_message .section}

`Cannot recognize table name or alias '...'. RefId: S02059`

## Probable Causes {#probable_causes .section}

In the query on a DFS table or a table joined by table joiners, this error occurs when a wildcard "\*" is used in a table name \(e.g. "tableName.\*"\) in the select statement, but that table is not included in the `from` clause. For example:

``` {#codeblock_ucy_wtl_jcc}
t1 = table(`a as id)
t2 = table(`b as id)
t3 = table(`c as id)

dbName = "dfs://test"
if (existsDatabase(dbName)) {
    dropDatabase(dbName)
}
db = database(dbName, VALUE, `a`b)
pt = db.createPartitionedTable(t1, `pt, `id)
pt.append!(t1)

select t3.* from pt
select t3.* from ej(t1, t2, `id) => Cannot recognize table name or alias 't3'.
```

## Solutions {#solutions .section}

When using a wildcard in a table name in the select statement, ensure that the corresponding table is also specified in the `from` clause.

``` {#codeblock_ljw_mxl_jcc}
select t3.* from ej(t1, t3, `id)
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

