# S02057 {#S02057}

## Error Code {#error_code .section}

S02057

## Error Message {#error_message .section}

`The 'kendall' function is not allowed in a distributed query. RefId: S02057`

## Probable Causes {#probable_causes .section}

This error occurs when using the `kendall` function in a DFS query. For example:

``` {#codeblock_ucy_wtl_jcc}
dbName = "dfs://test"
if (existsDatabase(dbName)) {
    dropDatabase(dbName)
}
t = table(2023.01.01..2023.01.03 as tradeDate, 1..3 as val)
db = database(dbName, VALUE, 2023.01.01..2023.01.03)
pt = db.createPartitionedTable(t, `pt, `tradeDate)
pt.append!(t)

select kendall(val, val) from pt => The 'kendall' function is not allowed in a distributed query.
```

## Solutions {#solutions .section}

Modify the query to avoid using the `kendall` function in a DFS query.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

