# S02055 {#S02055}

## Error Code {#error_code .section}

S02055

## Error Message {#error_message .section}

`The DISTINCT keyword cannot be used with group by, context by, or pivot by. RefId: S02055`

## Probable Causes {#probable_causes .section}

The `distinct` keyword eliminates all duplicate records. Therefore, it cannot be used with `group by`, `context by`, or `pivot by` clauses for further deduplication. For example:

``` {#codeblock_ucy_wtl_jcc}
def createMyTable(n) {
    intv = take(1..10, n)
    symbol = take(`a`b`c, n)
    id = rand(100, n)
    strv = take("abs" + string(1..10), n)
    doublev = rand(10.0, n)
    return table(intv, strv, doublev, id, symbol)
}

n = 100
t = createMyTable(n)

SELECT DISTINCT id FROM t GROUP BY id => The DISTINCT keyword cannot be used with group by, context by, or pivot by.
```

## Solutions {#solutions .section}

Remove the `group by`, `context by`, or `pivot by` clauses from the SQL statement with the `distinct` keyword.

``` {#codeblock_omd_4wl_jcc}
select DISTINCT id from t
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

