# S02054 {#S02054}

## Error Code {#error_code .section}

S02054

## Error Message {#error_message .section}

`Can't modify read only table. RefId: S02054`

## Probable Causes {#probable_causes .section}

This error occurs when deleting, modifying, or inserting data into a read-only table. For example:

``` {#codeblock_ucy_wtl_jcc}
def createMyTable(n) {
    intv = take(1..10, n)
    symbol = take(`a`b`c, n)
    id = rand(100, n)
    strv = take("abs" + string(1..10), n)
    doublev = rand(10.0, n)
    return table(intv, strv, doublev, id, symbol)
}
// Create a table
n = 100
t = createMyTable(n)

// Share the table and set to read-only
share(t, `shareReadOnlyTable, readonly=true)
delete from shareReadOnlyTable where id = 1
```

## Solutions {#solutions .section}

-   When sharing the table, set the *readonly* parameter to false.

    ``` {#codeblock_wqm_xwl_jcc}
    share(t, `shareTable, readonly=false)
    delete from shareTable where id = 1
    ```

-   If the table contains a small amount of data, copy the table data using the select statement and delete data from the copy.

    ``` {#codeblock_fy2_ywl_jcc}
    share(t, `shareReadOnlyTable, readonly=true)
    copyT = select * from shareReadOnlyTable;
    delete from copyT where id = 1
    ```


**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

