# S02052 {#S02052}

## Error Code {#error_code .section}

S02052

## Error Message {#error_message .section}

`The last column for "pivot by" clause must be a partitioning column. RefId: S02052`

## Probable Causes {#probable_causes .section}

When querying a DFS table using the `asis` function in the select statement, the last column in the `pivot by` clause must be a partitioning column. For example:

``` {#codeblock_ucy_wtl_jcc}
def createMyTable(n) {
    intv = take(1..10, n)
    symbol = take(`a`b`c, n)
    id = rand(100, n)
    strv = take("abs" + string(1..10), n)
    doublev = rand(10.0, n)
    return table(intv, strv, doublev, id, symbol)
}

// Create a database
dbName = "dfs://test"
if (existsDatabase(dbName)) {
    dropDatabase(dbName)
}
db = database(dbName, HASH, [INT, 2])

// Create a table
n = 100
t = createMyTable(n)
pt = createPartitionedTable(db, t, `pt, `intv)
pt.append!(t)

select asis(doublev) from pt pivot by id, symbol => The last column for "pivot by" clause must be a partitioning column.
```

## Solutions {#solutions .section}

Delete the `asis` function as follows:

``` {#codeblock_omd_4wl_jcc}
select doublev from pt pivot by id, symbol
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

