# S02044 {#S02044}

## Error Code {#error_code .section}

S02044

## Error Message {#error_message .section}

`Unexpected function arguments in analytic function. RefId: S02044`

## Probable Causes {#probable_causes .section}

When a query uses both an analytic function and a `group by` clause, the system checks the validity of the analytic function before performing it. This error occurs when the analytic function contains an unexpected number of arguments.

``` {#codeblock_ucy_wtl_jcc}
id = `XOM`GS`AAPL
val = 102.1 33.4 73.6
date = 2020.01.01 2020.01.02 2020.01.01
t = table(id, val, date);

select lead() over (partition by date) from t group by date, val => Unexpected function arguments in analytic function.
```

## Solutions {#solutions .section}

Ensure the analytic function meets the following conditions:

1.  Supported by DolphinDB. For supported analytic functions, refer to [Analytic Functions](../../Programming/SQLStatements/analytic_functions.md).
2.  Contain a valid number of arguments.

    ``` {#codeblock_ubs_45l_jcc}
    select lead(val) over (partition by date) from t group by date, val
    /* output
    date       val                 lead               
    ---------- ------------------- -------------------
    2020.01.01 73.599999999999994  102.099999999999994
    2020.01.01 102.099999999999994                    
    2020.01.02 33.399999999999998  
    */
    ```

3.  When used with a `group by` clause, the non-constant argument of the analytic function must be one of the columns specified in the `group by` clause or an expression involving these columns, such as `val+1`. Otherwise, an aggregate function must be applied to that column.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

