# S02042 {#S02042}

## Error Code {#error_code .section}

S02042

## Error Message {#error_message .section}

`Distributed queries do not support the 'exists' keyword. RefId:S02042`

## Probable Causes {#probable_causes .section}

Using the EXISTS keyword is not allowed in a distributed query.

For example,

``` {#codeblock_mbx_dpz_zbc}
dbName = "dfs://test"
if (existsDatabase(dbName)) {
	dropDatabase(dbName)
}
t = table(2023.01.01..2023.01.03 as tradeDate)
db = database(dbName, VALUE, 2023.01.01..2023.01.03)
pt = db.createPartitionedTable(t, `pt, `tradeDate)
pt.append!(t)

select * from pt where exists(select * from t where t.tradeDate=pt.tradeDate)
```

## Solutions {#solutions .section}

Check whether the EXISTS keyword is used in a distributed query.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

