# S02041 {#S02041}

## Error Code {#error_code .section}

S02041

## Error Message {#error_message .section}

`The nested joins in a query must return a table. RefId:S02041`

## Probable Causes {#probable_causes .section}

In a JOIN query, if there is a nested join query, the nested query must return a table.

For example, the error will occur if the nested JOIN query uses the EXEC statement and returns a scalar value.

``` {#codeblock_mbx_dpz_zbc}
t1 = table(`a as a)
t2 = table(`b as b)
t3 = table(`c as c)
select a from t cross join (exec first(b) from t1 cross join t2)
```

## Solutions {#solutions .section}

Avoid using the EXEC keyword in the nested JOIN subquery of a JOIN query.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

