# S02040 {#S02040}

## Error Code {#error_code .section}

S02040

## Error Message {#error_message .section}

`The temporal partitioning column <xxx> must be compared with a temporal object in the WHERE clause. RefId:S02040`

## Probable Causes {#probable_causes .section}

In the WHERE clause, a partitioning column of temporal type can only be compared with time values.

For example, comparing a temporal partitioning column with an integer will result in an error.

``` {#codeblock_mbx_dpz_zbc}
dbName = "dfs://test222"
if (existsDatabase(dbName)) {
	dropDatabase(dbName)
}
t = table(2023.01.01..2023.01.03 as tradeDate)
db = database(dbName, VALUE, 2023.01.01..2023.01.03)
pt = db.createPartitionedTable(t, `pt, `tradeDate)
pt.append!(t)

select * from pt where tradeDate > 1
```

## Solutions {#solutions .section}

Check if the WHERE clause contains comparisons between a temporal partitioning column and other data types.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

