# S02038 {#S02038}

## Error Code {#error_code .section}

S02038

## Error Message {#error_message .section}

`Order-sensitive or user-defined functions are not allowed in the order by clause […] for a query over a partitioned table. RefId:S02038`

## Probable Causes {#probable_causes .section}

In a distributed query, using order-sensitive or user-defined functions in an ORDER BY clause is not allowed.

For example, the `prev` and `udf` functions will raise this error.

``` {#codeblock_mbx_dpz_zbc}
dbName = "dfs://test"
if (existsDatabase(dbName)) {
    dropDatabase(dbName)
}
t = table(1..3 as id)
db = database(dbName, VALUE, 1..3)
pt = db.createPartitionedTable(t, `pt, `id)
pt.append!(t)
def udf(col) {
    return prev(col)
}
select * from pt order by prev(id)
select * from pt order by udf(id)
```

## Solutions {#solutions .section}

Check whether order-sensitive or user-defined functions are used in your ORDER BY clause.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

