# S02036 {#S02036}

## Error Code {#error_code .section}

S02036

## Error Message {#error_message .section}

`The size of the result returned by the where condition <xxx> does not match the number of rows in the table. RefId:S02036`

## Probable Causes {#probable_causes .section}

DolphinDB SQL processes the conditions in the WHERE clause on a column-by-column basis. Each condition's result must be a boolean vector of the same length as the number of rows in the selected table.

For example, the condition specified in the WHERE clause, `distinct(id)=1`, produces a result with fewer rows than the table "t", resulting in an error:

``` {#codeblock_mbx_dpz_zbc}
t = table([1, 1, 2, 3] as id)
select * from t where distinct(id)=1
```

## Solutions {#solutions .section}

Check if the conditions in the WHERE clause result in lengths that do not match the number of rows in the selected table.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

