# S02031 {#s02031}

## Error Code {#error_code .section}

S02031

## Error Message {#error_message .section}

`Only one parameter can be passed to null-filling operation <xxx> when it is used with PIVOT BY. RefId:S02031`

## Probable Causes {#probable_causes .section}

For a query using a PIVOT BY clause, attempting to use null-filling functions \(e.g., `ffill`, `bfill`, `lfill`\) with multiple arguments in the SELECT clause will result in an error.

For example:

``` {#codeblock_vlp_vx5_1bc}
sym = `C`MS`MS`MS`IBM`IBM`C`C`C
price= [49.6, 29.46, 29.52, 30.02, 174.97, 175.23, 50.76, 50.32, 51.29]
qty = [2200, 1900, 2100, , 6800, 5400, 1300, 2500, 8800]
timestamp = [09:34:07,09:35:42,09:36:51,09:36:59,09:35:47,09:36:26,09:34:16,09:35:26,09:36:12]
t = table(timestamp, sym, qty, price);

select ffill(qty, 1) from t pivot by sym, timestamp
```

## Solutions {#solutions .section}

Avoid setting the *limit* parameter for null-filling functions. The following query can be successfully executed:

``` {#codeblock_zwp_wx5_1bc}
select ffill(qty) from t pivot by sym, timestamp 
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

