# S02028 {#s02028}

## Error Code {#error_code .section}

S02028

## Error Message {#error_message .section}

`Only one parameter can be passed to row reduction operation <xxx> when it is used with PIVOT BY. RefId:S02028`

## Probable Causes {#probable_causes .section}

For a pivot table, each cell holds a single value aggregated from multiple groups. Therefore, if you try to use a row-based function in the SELECT clause and provide multiple arguments to that function, an error will be reported.

For example:

``` {#codeblock_znj_lx5_1bc}
sym = `C`MS`MS`MS`IBM`IBM`C`C`C
price= [49.6, 29.46, 29.52, 30.02, 174.97, 175.23, 50.76, 50.32, 51.29]
qty = [2200, 1900, 2100, , 6800, 5400, 1300, 2500, 8800]
timestamp = [09:34:07,09:35:42,09:36:51,09:36:59,09:35:47,09:36:26,09:34:16,09:35:26,09:36:12]
t = table(timestamp, sym, qty, price);

select rowSum(qty, price) from t pivot by sym, timestamp
```

## Solutions {#solutions .section}

Use unary row-based functions with only one parameter specified for *args*. The following query can be successfully executed:

``` {#codeblock_hzr_mx5_1bc}
select rowSum(qty) from t pivot by sym, timestamp
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

