# S02026 {#s02026}

## Error Code {#error_code .section}

S02026

## Error Message {#error_message .section}

`Function <xxx> cannot be used with CONTEXT BY. RefId:S02026`

## Probable Causes {#probable_causes .section}

This error occurs when using CONTEXT BY clause with aggregate functions that return a vector, such as `toArray`, `distinct`.

For example:

``` {#codeblock_ft4_dx5_1bc}
def fun(a) {
    return array(INT[],0,2).append!([1 2])
}

arr = 1..10
id = take(1..5,10)
t = table(arr, id)

select toArray(fun(arr)) from t context by id; 
select distinct(arr) from t context by id; 
```

## Solutions {#solutions .section}

Check whether the aggregate function used in the SELECT statement returns a vector.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

