# S02025 {#S02025}

## Error Code {#error_code .section}

S02025

## Error Message {#error_message .section}

`The where clause <xxx> of a distributed query should not use any aggregate or order-sensitive function. RefId: S02025`

## Probable Causes {#probable_causes .section}

This error occurs when the `where` clause uses an aggregate or order-sensitive function in a partitioned DFS table query. For example:

``` {#codeblock_ucy_wtl_jcc}
SELECT SearchPhrase FROM hits WHERE min(UserID) > 0 => The where clause [min(UserID) > 0] of a distributed query should not use any aggregate or order-sensitive function.
```

## Solutions {#solutions .section}

1.  Use the `having` clause to filter the aggregate results:

    ``` {#codeblock_uly_g5l_jcc}
    SELECT SearchPhrase FROM hits GROUP BY SearchPhrase HAVING min(UserID) > 0;
    ```

2.  If no filtering is needed, delete the `where` clause.
3.  If the queried table is not too large, load the table into memory and perform the query on the in-memory table:

    ``` {#codeblock_q25_35l_jcc}
    t = SELECT * FROM hits // Load the the content of the partitioned table hits into the in-memory table t
    SELECT SearchPhrase FROM t WHERE min(UserID) > 0
    ```


**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

