# S02024 {#s02024}

## Error Code {#error_code .section}

S02024

## Error Message {#error_message .section}

`Array vector does not support SYMBOL or STRING type. RefId:S02024`

## Probable Causes {#probable_causes .section}

For a query with a GROUP BY clause, if you attempt to apply a function that generates a STRING or SYMBOL array vector in the SELECT statement, an error will be thrown. The reason for this is that array vectors do not natively support STRING or SYMBOL data types.

For example, `toArray` applied to the "val" column \(of STRING type\) will result in an error.

``` {#codeblock_gxx_yw5_1bc}
t = table([1,1] as id, ["A", "B"] as val)
select toArray(val) from t group by id
```

## Solutions {#solutions .section}

Avoid using a function to generate a STRING or SYMBOL array vector in the SELECT statement for a query with GROUP BY clause.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

