# S02020 {#s02020}

## Error Code {#error_code .section}

S02020

## Error Message {#error_message .section}

`The grouping column <xxx> must be a vector. RefId:S02020`

## Probable Causes {#probable_causes .section}

This error occurs when the grouping column is not specified as a vector.

For example, if the following query includes a GROUP BY clause on "1", which is a scalar, it will trigger the error:

``` {#codeblock_hzc_xv5_1bc}
t = table([1] as val)
select sum(val) from t group by 1
```

## Solutions {#solutions .section}

Ensure that the grouping column is a vector that has the same size as the SELECT column.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

