# S02018 {#s02018}

## Error Code {#error_code .section}

S02018

## Error Message {#error_message .section}

`The grouping column <xxx> cannot be an array vector. RefId:S02018`

## Probable Causes {#probable_causes .section}

The array vector column cannot be grouped. Therefore, this error occurs when using a GROUP BY clause on an array vector column.

For example, if the following query includes a GROUP BY on the "grp" column, which is an array vector, it will trigger the error:

``` {#codeblock_zpp_qv5_1bc}
t = table(array(INT[], 0, 10).append!([1 2, 3]) as grp, [1,1] as val)
select sum(val) from t group by grp
```

## Solutions {#solutions .section}

Ensure that the grouping column is not an array vector.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

