# S02016 {#s02016}

## Error Code {#error_code .section}

S02016

## Error Message {#error_message .section}

`Invalid columns <xxx>. RefId:S02016`

## Probable Causes {#probable_causes .section}

The use of a comma \(,\) to represent a cross join or inner join is not supported when performing multiple joins. If a comma is used instead of proper join syntax, it splits the FROM clause into multiple expressions and the order of execution will be changed. This error occurs when the join condition contains unexpected columns.

For example, the `inner join` operation on "t3" and "t2" with the ON clause would be executed first, instead of the `cross join` on "t1" and "t3". As a result, the "t1.id" column will be parsed as an invalid join column for `inner join`, causing an error.

``` {#codeblock_rh2_jv5_1bc}
t1 = table(1..10 as id, rand(1..10, 10) as val);
t2 = table(1..10 as id, rand(1..10, 10) as val);
t3 = table(1..10 as id, rand(1..10, 10) as val);

select * from t1, t3 inner join t2 on t1.id = t2.id;
```

## Solutions {#solutions .section}

Replace the comma with the `cross join` keyword as follows.

``` {#codeblock_w5q_jv5_1bc}
select * from t1 cross join t3 inner join t2 on t1.id = t2.id;
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

