# S02015 {#S02015}

## Error Code {#error_code .section}

S02015

## Error Message {#error_message .section}

`The table object must be a DFS table. RefId: S02015`

## Probable Causes {#probable_causes .section}

In a `pivot by` query, when using the `asis` function to display all query results without deduplication, the queried table must be a partitioned DFS table; otherwise, this error occurs. For example:

``` {#codeblock_ucy_wtl_jcc}
time = [10:20:44,10:20:44,10:20:44,10:20:45,10:20:45,10:20:45,10:20:46,10:20:46,10:20:46,10:20:46,10:20:46,10:20:46]
sym = ["A","B","C","A","B","C","A","B","C","A","B","C"]
value = [510,434,999,837,402,615,495,885,745,968,975,165]
t = table(time,sym,value)

select asis(value) from t pivot by time,sym => The table object must be a DFS table.
```

## Solutions {#solutions .section}

Ensure that when using the `asis` function in a `pivot by` query, the queried table is a DFS table.

Additionally, the conditions for the combined use of `asis` and `pivot by` specified in [pivot by](../../Programming/SQLStatements/pivotBy.md) should also be met.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

