# S02012 {#s02012}

## Error Code {#error_code .section}

S02012

## Error Message {#error_message .section}

`Not support to create temporary table whose name has already been used. RefId:S02012`

## Probable Causes {#probable_causes .section}

For versions prior to 2.00.10, the name of temporary table defined using `with as` in a SQL statement cannot be the same as the name of other variables.

**Note**: This error was fixed since version 2.00.10.

For example, duplicate table name "t1" exists in the following script.

``` {#codeblock_qhy_p55_1bc}
t1 = 1
t2 = table(1..3 as id)
with t1 as (select * from t2) select * from t1
```

## Solutions {#solutions .section}

Check whether duplicate variable name exists and rename the temporary table.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

