# S02011 {#s02011}

## Error Code {#error_code .section}

S02011

## Error Message {#error_message .section}

`SQL context is not initialized yet. RefId:S02011`

## Probable Causes {#probable_causes .section}

This error occurs when the SQL statement is incomplete.

For example:

``` {#codeblock_tdz_c55_1bc}
// create table
n = 10000
type = take(1..10, n)
sys = take(char('A' + 0..3), n)
t = table(type, sys)

select x; // throw an exception due to the absence of a FROM clause
select from t; // throw an exception due to an absent of obj to be selected
select x from t; // successfully executed
```

## Solutions {#solutions .section}

Ensure that the SQL statement contains all the required clauses and that the syntax is correct.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

