# S02010 {#s02010}

## Error Code {#error_code .section}

S02010

## Error Message {#error_message .section}

`All columns must be of the same length. RefId:S02010`

## Probable Causes {#probable_causes .section}

DolphinDB enforces that all columns in a table must have equal lengths. This error may occur in the following cases:

1.  When constructing a table by passing vectors of mismatched lengths, e.g., `t = table(1..10 as id, rand(1..10, 100000) as col2)`.

2.  When executing SQL queries where the SELECT columns produce results of different lengths, e.g., `select id, distinct(val) from t`.


## Solutions {#solutions .section}

1.  Verify that the columns being used to construct the table have equal lengths.

    ``` {#codeblock_c1b_wt5_1bc}
    table(1..10 as id, rand(1..10, 100000) as val) 
    ==> table(1..10 as id, rand(1..10, 10) as val)；
    ```

2.  For SQL queries, confirm that the columns or expressions specified in the SELECT statement will produce results of matching lengths.

    ``` {#codeblock_fgn_zt5_1bc}
    select id, distinct(val) from t 
    ==> select id, val from t；
    ```


**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

